/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.6.19-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: consu53_DBStructure
-- ------------------------------------------------------
-- Server version	10.6.19-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `consu53_DBStructure`
--


--
-- Table structure for table `Attendees`
--

DROP TABLE IF EXISTS `Attendees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Attendees` (
  `attendee_id` int(10) NOT NULL AUTO_INCREMENT,
  `claim_id` int(15) NOT NULL,
  `attendee_email` varchar(250) NOT NULL,
  `attendee_fname` varchar(50) DEFAULT NULL,
  `attendee_lname` varchar(50) DEFAULT NULL,
  `attendee_contact` varchar(20) DEFAULT NULL,
  `user_id` int(15) NOT NULL,
  `company_id` int(15) NOT NULL,
  PRIMARY KEY (`attendee_id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Attendees`
--

LOCK TABLES `Attendees` WRITE;
/*!40000 ALTER TABLE `Attendees` DISABLE KEYS */;
/*!40000 ALTER TABLE `Attendees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assignment` (
  `assignment_id` int(20) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `project_id` int(15) NOT NULL,
  `assignment_name` varchar(150) NOT NULL,
  PRIMARY KEY (`assignment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `basic_comp_policy`
--

DROP TABLE IF EXISTS `basic_comp_policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `basic_comp_policy` (
  `BasicPolicyId` int(11) NOT NULL,
  `companyId` int(10) NOT NULL,
  `policy_name` varchar(50) NOT NULL,
  `Description` varchar(200) NOT NULL,
  `BusinessPolicyId` varchar(100) NOT NULL,
  `Operator` varchar(50) NOT NULL,
  `Value` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL DEFAULT 'USD',
  `IsDeleted` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`BasicPolicyId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `basic_comp_policy`
--

LOCK TABLES `basic_comp_policy` WRITE;
/*!40000 ALTER TABLE `basic_comp_policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `basic_comp_policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `businesspolicycondition`
--

DROP TABLE IF EXISTS `businesspolicycondition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `businesspolicycondition` (
  `condition_id` int(10) NOT NULL AUTO_INCREMENT,
  `company_id` int(10) NOT NULL,
  `BusinessRuleId` int(10) NOT NULL,
  `category` varchar(100) NOT NULL,
  `Operator` varchar(50) NOT NULL,
  `Values` varchar(200) NOT NULL,
  `type_of_operation` varchar(10) NOT NULL,
  `IsDeleted` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`condition_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `businesspolicycondition`
--

LOCK TABLES `businesspolicycondition` WRITE;
/*!40000 ALTER TABLE `businesspolicycondition` DISABLE KEYS */;
/*!40000 ALTER TABLE `businesspolicycondition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `businesspolicyreference`
--

DROP TABLE IF EXISTS `businesspolicyreference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `businesspolicyreference` (
  `comp_pref_id` int(5) NOT NULL,
  `category_type` varchar(50) NOT NULL,
  `BusinessPolicyId` varchar(50) NOT NULL,
  `Operator` varchar(50) NOT NULL,
  `IsActive` bit(1) NOT NULL,
  PRIMARY KEY (`comp_pref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `businesspolicyreference`
--

LOCK TABLES `businesspolicyreference` WRITE;
/*!40000 ALTER TABLE `businesspolicyreference` DISABLE KEYS */;
/*!40000 ALTER TABLE `businesspolicyreference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `businessrules`
--

DROP TABLE IF EXISTS `businessrules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `businessrules` (
  `BusinessRuleId` int(5) NOT NULL AUTO_INCREMENT,
  `policy_type` varchar(50) NOT NULL DEFAULT 'advance',
  `policy_name` varchar(100) NOT NULL,
  `BusinessPolicyId` varchar(50) NOT NULL,
  `CompanyId` int(5) NOT NULL,
  `Operator` varchar(50) NOT NULL,
  `Value` varchar(200) NOT NULL,
  `currency` varchar(100) NOT NULL DEFAULT 'USD',
  `RuleQuery` varchar(200) NOT NULL,
  `Description` varchar(200) NOT NULL,
  `IsMandetory` bit(1) NOT NULL,
  `IsDeleted` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`BusinessRuleId`),
  KEY `CompanyId` (`CompanyId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `businessrules`
--

LOCK TABLES `businessrules` WRITE;
/*!40000 ALTER TABLE `businessrules` DISABLE KEYS */;
/*!40000 ALTER TABLE `businessrules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claim_loghistory`
--

DROP TABLE IF EXISTS `claim_loghistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claim_loghistory` (
  `claim_logid` int(15) NOT NULL AUTO_INCREMENT,
  `claim_id` int(15) DEFAULT NULL,
  `company_id` int(15) DEFAULT NULL,
  `user_id` int(15) DEFAULT NULL,
  `claim_name` varchar(100) DEFAULT NULL,
  `claim_date` datetime DEFAULT NULL,
  `claim_state` varchar(50) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `comments` varchar(1000) DEFAULT NULL,
  `performed_by` varchar(200) DEFAULT NULL,
  `createdOn` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `role` varchar(100) DEFAULT NULL,
  `action_by` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`claim_logid`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claim_loghistory`
--

LOCK TABLES `claim_loghistory` WRITE;
/*!40000 ALTER TABLE `claim_loghistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `claim_loghistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claimtransactions`
--

DROP TABLE IF EXISTS `claimtransactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claimtransactions` (
  `trns_sl_no` int(10) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `user_id` int(10) NOT NULL,
  `claim_id` int(10) NOT NULL,
  `tran_date` date NOT NULL,
  `description` varchar(200) NOT NULL,
  `expense_type` varchar(50) NOT NULL,
  `category` varchar(50) NOT NULL,
  `trns_amt` decimal(50,2) NOT NULL,
  `currency` varchar(10) NOT NULL,
  `Project` varchar(200) DEFAULT 'Unknown Project',
  `Location` varchar(200) DEFAULT NULL,
  `Department` varchar(200) DEFAULT NULL,
  `billable` varchar(50) NOT NULL,
  `Reimbursable` varchar(50) NOT NULL,
  `Client` varchar(200) DEFAULT NULL,
  `receipt` varchar(255) NOT NULL,
  `CostCenter` varchar(200) DEFAULT NULL,
  `ProfitCenter` varchar(200) DEFAULT NULL,
  `Class` varchar(200) DEFAULT NULL,
  `Program` varchar(200) DEFAULT NULL,
  `Campaign` varchar(200) DEFAULT NULL,
  `month` varchar(20) NOT NULL,
  `status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`trns_sl_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claimtransactions`
--

LOCK TABLES `claimtransactions` WRITE;
/*!40000 ALTER TABLE `claimtransactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `claimtransactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claimtransactions_pivot`
--

DROP TABLE IF EXISTS `claimtransactions_pivot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claimtransactions_pivot` (
  `CostCenter` varchar(200) DEFAULT NULL,
  `ProfitCenter` varchar(200) DEFAULT NULL,
  `Location` varchar(200) DEFAULT NULL,
  `expense_type` varchar(50) DEFAULT NULL,
  `category` varchar(50) DEFAULT NULL,
  `Jan` decimal(65,2) DEFAULT NULL,
  `Feb` decimal(65,2) DEFAULT NULL,
  `Mar` decimal(65,2) DEFAULT NULL,
  `Apr` decimal(65,2) DEFAULT NULL,
  `May` decimal(65,2) DEFAULT NULL,
  `Jun` decimal(65,2) DEFAULT NULL,
  `Jul` decimal(65,2) DEFAULT NULL,
  `Aug` decimal(65,2) DEFAULT NULL,
  `Sep` decimal(65,2) DEFAULT NULL,
  `Oct` decimal(65,2) DEFAULT NULL,
  `Nov` decimal(65,2) DEFAULT NULL,
  `Decm` decimal(65,2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claimtransactions_pivot`
--

LOCK TABLES `claimtransactions_pivot` WRITE;
/*!40000 ALTER TABLE `claimtransactions_pivot` DISABLE KEYS */;
/*!40000 ALTER TABLE `claimtransactions_pivot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `company_preferencedata`
--

DROP TABLE IF EXISTS `company_preferencedata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_preferencedata` (
  `prefdata_id` int(5) NOT NULL AUTO_INCREMENT,
  `prefdata_name` varchar(50) NOT NULL,
  `comp_pref_id` int(5) NOT NULL,
  `company_id` int(5) NOT NULL,
  `IsActive` bit(1) NOT NULL,
  `IsDeleted` bit(1) NOT NULL,
  PRIMARY KEY (`prefdata_id`),
  KEY `comp_pref_id` (`comp_pref_id`,`company_id`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `company_preferencedata`
--

LOCK TABLES `company_preferencedata` WRITE;
/*!40000 ALTER TABLE `company_preferencedata` DISABLE KEYS */;
/*!40000 ALTER TABLE `company_preferencedata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `companyexpcatmaster`
--

DROP TABLE IF EXISTS `companyexpcatmaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companyexpcatmaster` (
  `ExpTypeID` int(5) NOT NULL,
  `company_id` int(5) NOT NULL,
  `ExpenseType` varchar(50) NOT NULL,
  `ExpCategoryName` varchar(50) NOT NULL,
  `CostCenter` varchar(50) DEFAULT NULL,
  `ProfitCenter` varchar(50) DEFAULT NULL,
  `Location` varchar(50) DEFAULT NULL,
  `Department` varchar(50) DEFAULT NULL,
  `Client` varchar(50) DEFAULT NULL,
  `Project` varchar(50) DEFAULT NULL,
  `Class` varchar(50) DEFAULT NULL,
  `Program` varchar(50) DEFAULT NULL,
  `Compaign` varchar(50) DEFAULT NULL,
  `IsActive` bit(1) NOT NULL DEFAULT b'1',
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `companyexpcatmaster`
--

LOCK TABLES `companyexpcatmaster` WRITE;
/*!40000 ALTER TABLE `companyexpcatmaster` DISABLE KEYS */;
/*!40000 ALTER TABLE `companyexpcatmaster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `companyinfo`
--

DROP TABLE IF EXISTS `companyinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companyinfo` (
  `company_id` int(5) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(100) NOT NULL,
  `address1` varchar(50) NOT NULL,
  `address2` varchar(50) DEFAULT NULL,
  `City` varchar(50) NOT NULL,
  `State` varchar(50) NOT NULL,
  `Zip` varchar(10) NOT NULL,
  `Country` varchar(100) NOT NULL,
  `company_phone` varchar(15) NOT NULL,
  `primary_email` varchar(100) NOT NULL,
  `alternate_email` varchar(100) NOT NULL,
  `Website` varchar(100) NOT NULL,
  `CreatedOn` date NOT NULL,
  `LastUpdatedOn` datetime NOT NULL,
  `CreatedBy` varchar(50) NOT NULL,
  `Pref_Ids` varchar(100) NOT NULL,
  `exp_level_pref` varchar(20) NOT NULL,
  `buss_policy_pref` varchar(20) NOT NULL,
  `currencies` varchar(1000) NOT NULL,
  `default_currency` varchar(50) NOT NULL DEFAULT 'USD',
  `distance_unit` varchar(50) NOT NULL DEFAULT 'miles',
  `exp_date` date NOT NULL DEFAULT '0000-00-00',
  `IsDeleted` bit(1) NOT NULL,
  PRIMARY KEY (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `companyinfo`
--

LOCK TABLES `companyinfo` WRITE;
/*!40000 ALTER TABLE `companyinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `companyinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `companypriceplan`
--

DROP TABLE IF EXISTS `companypriceplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companypriceplan` (
  `slno` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `no_of_users` int(15) NOT NULL,
  `months` int(5) NOT NULL,
  `exp_date` date NOT NULL,
  `last_update` date NOT NULL,
  `plan_type` varchar(50) NOT NULL,
  `amt_paid` float NOT NULL,
  `discount` float NOT NULL DEFAULT 0,
  `IsExpired` int(1) NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `companypriceplan`
--

LOCK TABLES `companypriceplan` WRITE;
/*!40000 ALTER TABLE `companypriceplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `companypriceplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cost_centre`
--

DROP TABLE IF EXISTS `cost_centre`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cost_centre` (
  `company_id` int(10) NOT NULL,
  `field1` varchar(50) NOT NULL,
  `field2` varchar(50) NOT NULL,
  `field3` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cost_centre`
--

LOCK TABLES `cost_centre` WRITE;
/*!40000 ALTER TABLE `cost_centre` DISABLE KEYS */;
/*!40000 ALTER TABLE `cost_centre` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countrylist`
--

DROP TABLE IF EXISTS `countrylist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `countrylist` (
  `slno` int(10) NOT NULL AUTO_INCREMENT,
  `country` varchar(70) NOT NULL,
  `country_code` varchar(5) NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countrylist`
--

LOCK TABLES `countrylist` WRITE;
/*!40000 ALTER TABLE `countrylist` DISABLE KEYS */;
/*!40000 ALTER TABLE `countrylist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `creditcardtransaction`
--

DROP TABLE IF EXISTS `creditcardtransaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `creditcardtransaction` (
  `transaction_id` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `credit_card_no` varchar(30) NOT NULL,
  `credit_card_type` varchar(30) NOT NULL,
  `user_id` int(15) NOT NULL,
  `paid_amount` int(15) NOT NULL,
  `payment_date` date NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `creditcardtransaction`
--

LOCK TABLES `creditcardtransaction` WRITE;
/*!40000 ALTER TABLE `creditcardtransaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `creditcardtransaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currency` (
  `isoCode` varchar(3) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `dollar_value` float NOT NULL,
  PRIMARY KEY (`isoCode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currency`
--

LOCK TABLES `currency` WRITE;
/*!40000 ALTER TABLE `currency` DISABLE KEYS */;
/*!40000 ALTER TABLE `currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currency_update`
--

DROP TABLE IF EXISTS `currency_update`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currency_update` (
  `slno` int(15) NOT NULL AUTO_INCREMENT,
  `isoCode` varchar(6) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `dollar_value` float NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currency_update`
--

LOCK TABLES `currency_update` WRITE;
/*!40000 ALTER TABLE `currency_update` DISABLE KEYS */;
/*!40000 ALTER TABLE `currency_update` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `detailsofpolicycheck`
--

DROP TABLE IF EXISTS `detailsofpolicycheck`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `detailsofpolicycheck` (
  `policy_check_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `claim_id` int(15) DEFAULT NULL,
  `transaction_id` int(15) NOT NULL,
  `trans_type` varchar(20) NOT NULL,
  `BusinessRuleId` int(15) NOT NULL,
  `comment` varchar(20) NOT NULL,
  PRIMARY KEY (`policy_check_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `detailsofpolicycheck`
--

LOCK TABLES `detailsofpolicycheck` WRITE;
/*!40000 ALTER TABLE `detailsofpolicycheck` DISABLE KEYS */;
/*!40000 ALTER TABLE `detailsofpolicycheck` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expensecategorymaster`
--

DROP TABLE IF EXISTS `expensecategorymaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expensecategorymaster` (
  `ExpTypeID` int(5) NOT NULL AUTO_INCREMENT,
  `ExpenseType` varchar(50) NOT NULL,
  `ExpCategoryName` varchar(50) NOT NULL,
  PRIMARY KEY (`ExpTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expensecategorymaster`
--

LOCK TABLES `expensecategorymaster` WRITE;
/*!40000 ALTER TABLE `expensecategorymaster` DISABLE KEYS */;
/*!40000 ALTER TABLE `expensecategorymaster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expenseclaims`
--

DROP TABLE IF EXISTS `expenseclaims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expenseclaims` (
  `claim_id` int(5) NOT NULL AUTO_INCREMENT,
  `company_id` int(10) NOT NULL,
  `claim_name` varchar(100) NOT NULL,
  `claim_amount` decimal(50,2) NOT NULL,
  `currency` varchar(10) NOT NULL,
  `description` varchar(50) NOT NULL,
  `approve_status` varchar(50) NOT NULL,
  `claim_state` varchar(500) DEFAULT NULL,
  `WFStep` int(6) NOT NULL,
  `approver_id` int(10) NOT NULL,
  `approver` varchar(100) NOT NULL,
  `created_by` varchar(100) NOT NULL,
  `created_on` date NOT NULL,
  `user_id` int(10) NOT NULL,
  `IsProcessed` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`claim_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expenseclaims`
--

LOCK TABLES `expenseclaims` WRITE;
/*!40000 ALTER TABLE `expenseclaims` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenseclaims` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expresscheckoutpayment`
--

DROP TABLE IF EXISTS `expresscheckoutpayment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expresscheckoutpayment` (
  `transaction_id` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `user_id` int(15) NOT NULL,
  `payment_date` date NOT NULL,
  `token` varchar(50) NOT NULL,
  `paid_amount` int(15) NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expresscheckoutpayment`
--

LOCK TABLES `expresscheckoutpayment` WRITE;
/*!40000 ALTER TABLE `expresscheckoutpayment` DISABLE KEYS */;
/*!40000 ALTER TABLE `expresscheckoutpayment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `externalapprover`
--

DROP TABLE IF EXISTS `externalapprover`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `externalapprover` (
  `approver_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `approver_email` varchar(100) NOT NULL,
  `unique_code` varchar(7) NOT NULL,
  `eSign` varchar(200) NOT NULL,
  PRIMARY KEY (`approver_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `externalapprover`
--

LOCK TABLES `externalapprover` WRITE;
/*!40000 ALTER TABLE `externalapprover` DISABLE KEYS */;
/*!40000 ALTER TABLE `externalapprover` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `information`
--

DROP TABLE IF EXISTS `information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `information` (
  `info_id` int(5) NOT NULL AUTO_INCREMENT,
  `key` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`info_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `information`
--

LOCK TABLES `information` WRITE;
/*!40000 ALTER TABLE `information` DISABLE KEYS */;
/*!40000 ALTER TABLE `information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lookupdata`
--

DROP TABLE IF EXISTS `lookupdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lookupdata` (
  `LookupDataID` int(5) NOT NULL AUTO_INCREMENT,
  `LookupMasterID` int(5) NOT NULL,
  `CategoryCode` varchar(50) DEFAULT NULL,
  `CategoyDataID` int(5) DEFAULT NULL,
  `ParentLookupDataID` int(5) DEFAULT NULL,
  `Title` varchar(50) DEFAULT NULL,
  `Description` varchar(50) DEFAULT NULL,
  `Attribute1` varchar(50) DEFAULT NULL,
  `Attribute2` varchar(50) DEFAULT NULL,
  `Attribute3` varchar(50) DEFAULT NULL,
  `LastUpdatedOn` datetime DEFAULT NULL,
  `IsDeleted` bit(1) DEFAULT NULL,
  PRIMARY KEY (`LookupDataID`),
  KEY `LookupMasterID` (`LookupMasterID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lookupdata`
--

LOCK TABLES `lookupdata` WRITE;
/*!40000 ALTER TABLE `lookupdata` DISABLE KEYS */;
/*!40000 ALTER TABLE `lookupdata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lookupmaster`
--

DROP TABLE IF EXISTS `lookupmaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lookupmaster` (
  `LookupMasterID` int(5) NOT NULL AUTO_INCREMENT,
  `CategoryCode` varchar(50) DEFAULT NULL,
  `CategoryTitle` varchar(50) DEFAULT NULL,
  `Description` varchar(50) DEFAULT NULL,
  `Attribute1Name` varchar(50) DEFAULT NULL,
  `Attribute2Name` varchar(50) DEFAULT NULL,
  `Attribute3Name` varchar(50) DEFAULT NULL,
  `LastUpdatedOn` datetime DEFAULT NULL,
  `IsDeleted` bit(1) DEFAULT NULL,
  PRIMARY KEY (`LookupMasterID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lookupmaster`
--

LOCK TABLES `lookupmaster` WRITE;
/*!40000 ALTER TABLE `lookupmaster` DISABLE KEYS */;
/*!40000 ALTER TABLE `lookupmaster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `managers`
--

DROP TABLE IF EXISTS `managers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `managers` (
  `manager_id` int(10) NOT NULL,
  `company_id` int(10) NOT NULL,
  `approval_limit` decimal(40,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`manager_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `managers`
--

LOCK TABLES `managers` WRITE;
/*!40000 ALTER TABLE `managers` DISABLE KEYS */;
/*!40000 ALTER TABLE `managers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `paymentdetails`
--

DROP TABLE IF EXISTS `paymentdetails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `paymentdetails` (
  `payment_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `exp_date` date NOT NULL,
  `paid_amount` int(15) NOT NULL,
  `transaction_id` varchar(500) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `paymentdetails`
--

LOCK TABLES `paymentdetails` WRITE;
/*!40000 ALTER TABLE `paymentdetails` DISABLE KEYS */;
/*!40000 ALTER TABLE `paymentdetails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preference4user`
--

DROP TABLE IF EXISTS `preference4user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `preference4user` (
  `slno` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `CostCenter` int(15) DEFAULT NULL,
  `ProfitCenter` int(15) DEFAULT NULL,
  `Location` int(15) DEFAULT NULL,
  `Department` int(15) DEFAULT NULL,
  `Client` int(15) DEFAULT NULL,
  `Project` int(15) DEFAULT NULL,
  `Class` int(15) DEFAULT NULL,
  `Program` int(15) DEFAULT NULL,
  `Campaign` int(15) DEFAULT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preference4user`
--

LOCK TABLES `preference4user` WRITE;
/*!40000 ALTER TABLE `preference4user` DISABLE KEYS */;
/*!40000 ALTER TABLE `preference4user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preference_master`
--

DROP TABLE IF EXISTS `preference_master`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `preference_master` (
  `pref_id` int(5) NOT NULL AUTO_INCREMENT,
  `pref_data` varchar(50) NOT NULL,
  `IsDeleted` bit(1) NOT NULL,
  PRIMARY KEY (`pref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preference_master`
--

LOCK TABLES `preference_master` WRITE;
/*!40000 ALTER TABLE `preference_master` DISABLE KEYS */;
/*!40000 ALTER TABLE `preference_master` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pricingplan`
--

DROP TABLE IF EXISTS `pricingplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pricingplan` (
  `sl_no` int(15) NOT NULL AUTO_INCREMENT,
  `min_users` int(10) NOT NULL,
  `max_users` int(15) NOT NULL,
  `expensePlusTimeTracking` float NOT NULL,
  `timeTrackingOnly` float NOT NULL,
  `expenseOnly` float NOT NULL,
  `discountPercent` float NOT NULL,
  PRIMARY KEY (`sl_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pricingplan`
--

LOCK TABLES `pricingplan` WRITE;
/*!40000 ALTER TABLE `pricingplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `pricingplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_assignment_tbl`
--

DROP TABLE IF EXISTS `project_assignment_tbl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_assignment_tbl` (
  `slno` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `project_id` varchar(200) NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_assignment_tbl`
--

LOCK TABLES `project_assignment_tbl` WRITE;
/*!40000 ALTER TABLE `project_assignment_tbl` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_assignment_tbl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projectallocation`
--

DROP TABLE IF EXISTS `projectallocation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `projectallocation` (
  `sl_no` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `username` varchar(500) NOT NULL,
  `projects` varchar(2000) NOT NULL,
  PRIMARY KEY (`sl_no`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projectallocation`
--

LOCK TABLES `projectallocation` WRITE;
/*!40000 ALTER TABLE `projectallocation` DISABLE KEYS */;
/*!40000 ALTER TABLE `projectallocation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `projects` (
  `project_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `project_name` varchar(150) NOT NULL,
  PRIMARY KEY (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `receipts`
--

DROP TABLE IF EXISTS `receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `receipts` (
  `receipt_id` int(10) NOT NULL AUTO_INCREMENT,
  `company_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `receipt` varchar(255) NOT NULL,
  `category_id` int(5) NOT NULL DEFAULT 0,
  PRIMARY KEY (`receipt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `receipts`
--

LOCK TABLES `receipts` WRITE;
/*!40000 ALTER TABLE `receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rolemaster`
--

DROP TABLE IF EXISTS `rolemaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rolemaster` (
  `role_id` int(5) NOT NULL,
  `role_name` varchar(50) NOT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rolemaster`
--

LOCK TABLES `rolemaster` WRITE;
/*!40000 ALTER TABLE `rolemaster` DISABLE KEYS */;
/*!40000 ALTER TABLE `rolemaster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `submittedtimesheet`
--

DROP TABLE IF EXISTS `submittedtimesheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `submittedtimesheet` (
  `timesheet_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `user` varchar(100) NOT NULL,
  `approver_id` int(15) NOT NULL,
  `type_of_view` varchar(50) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `working_hours` float NOT NULL,
  `time_off` float NOT NULL,
  `over_time` float NOT NULL,
  `total_hours` float NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'submitted',
  `comment` varchar(2000) NOT NULL,
  `eSign` varchar(200) NOT NULL,
  `approvedDateTime` datetime NOT NULL,
  `approvedFromIpAddress` varchar(50) NOT NULL,
  PRIMARY KEY (`timesheet_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `submittedtimesheet`
--

LOCK TABLES `submittedtimesheet` WRITE;
/*!40000 ALTER TABLE `submittedtimesheet` DISABLE KEYS */;
/*!40000 ALTER TABLE `submittedtimesheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temp_company`
--

DROP TABLE IF EXISTS `temp_company`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temp_company` (
  `slno` int(5) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(100) NOT NULL,
  `website` varchar(100) NOT NULL,
  `primary_email` varchar(100) NOT NULL,
  `alternate_email` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `address1` varchar(120) NOT NULL,
  `address2` varchar(120) NOT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `zip` int(10) NOT NULL,
  `user_id` varchar(100) NOT NULL,
  `password` varchar(50) NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temp_company`
--

LOCK TABLES `temp_company` WRITE;
/*!40000 ALTER TABLE `temp_company` DISABLE KEYS */;
/*!40000 ALTER TABLE `temp_company` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temp_query`
--

DROP TABLE IF EXISTS `temp_query`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temp_query` (
  `query_id` int(10) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `condition` varchar(50) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`query_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temp_query`
--

LOCK TABLES `temp_query` WRITE;
/*!40000 ALTER TABLE `temp_query` DISABLE KEYS */;
/*!40000 ALTER TABLE `temp_query` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `temp_trns_table`
--

DROP TABLE IF EXISTS `temp_trns_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temp_trns_table` (
  `trns_sl_no` int(10) NOT NULL AUTO_INCREMENT,
  `company_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `tran_date` date NOT NULL,
  `description` varchar(100) NOT NULL,
  `expense_type` varchar(50) NOT NULL,
  `category` varchar(50) NOT NULL,
  `trns_amt` decimal(50,2) NOT NULL,
  `Project` varchar(200) DEFAULT 'Not Added',
  `billable` varchar(100) NOT NULL,
  `Location` varchar(200) DEFAULT NULL,
  `Department` varchar(200) DEFAULT NULL,
  `Reimbursable` varchar(50) NOT NULL,
  `Client` varchar(200) DEFAULT NULL,
  `receipt` varchar(255) NOT NULL DEFAULT 'NULL',
  `currency` varchar(20) NOT NULL,
  `CostCenter` varchar(200) DEFAULT NULL,
  `ProfitCenter` varchar(200) DEFAULT NULL,
  `Class` varchar(200) DEFAULT NULL,
  `Program` varchar(200) DEFAULT NULL,
  `Campaign` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`trns_sl_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `temp_trns_table`
--

LOCK TABLES `temp_trns_table` WRITE;
/*!40000 ALTER TABLE `temp_trns_table` DISABLE KEYS */;
/*!40000 ALTER TABLE `temp_trns_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tempattendeetbl`
--

DROP TABLE IF EXISTS `tempattendeetbl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tempattendeetbl` (
  `slno` int(15) NOT NULL AUTO_INCREMENT,
  `attendee_email` varchar(250) NOT NULL,
  `attendee_fname` varchar(50) NOT NULL,
  `attendee_lname` varchar(50) NOT NULL,
  `attendee_contact` varchar(50) NOT NULL,
  `user_id` int(15) NOT NULL,
  `company_id` int(15) NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tempattendeetbl`
--

LOCK TABLES `tempattendeetbl` WRITE;
/*!40000 ALTER TABLE `tempattendeetbl` DISABLE KEYS */;
/*!40000 ALTER TABLE `tempattendeetbl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tempplan`
--

DROP TABLE IF EXISTS `tempplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tempplan` (
  `slno` int(5) NOT NULL AUTO_INCREMENT,
  `no_of_users` int(15) NOT NULL,
  `months` int(5) NOT NULL,
  `exp_date` date NOT NULL,
  `last_update` date NOT NULL,
  `plan_type` varchar(50) NOT NULL,
  `amt_paid` int(20) NOT NULL,
  `discount` float NOT NULL DEFAULT 0,
  `email_id` varchar(100) NOT NULL,
  `company_id` int(15) NOT NULL DEFAULT 0,
  PRIMARY KEY (`slno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tempplan`
--

LOCK TABLES `tempplan` WRITE;
/*!40000 ALTER TABLE `tempplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `tempplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timesheethistory`
--

DROP TABLE IF EXISTS `timesheethistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timesheethistory` (
  `history_id` int(20) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) DEFAULT NULL,
  `timesheet_id` int(15) DEFAULT NULL,
  `user_id` int(15) DEFAULT NULL,
  `action_performed` varchar(300) DEFAULT NULL,
  `action_performed_by` varchar(500) DEFAULT NULL,
  `action_timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`history_id`)
) ENGINE=MyISAM AUTO_INCREMENT=116 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timesheethistory`
--

LOCK TABLES `timesheethistory` WRITE;
/*!40000 ALTER TABLE `timesheethistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `timesheethistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timesheetmanagers`
--

DROP TABLE IF EXISTS `timesheetmanagers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timesheetmanagers` (
  `timesheetManagerId` int(15) NOT NULL AUTO_INCREMENT,
  `employee_id` int(15) NOT NULL,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `managerEmail` varchar(200) NOT NULL,
  `userEmail` varchar(200) NOT NULL,
  `firstname` varchar(100) NOT NULL,
  `lastname` varchar(100) NOT NULL,
  PRIMARY KEY (`timesheetManagerId`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timesheetmanagers`
--

LOCK TABLES `timesheetmanagers` WRITE;
/*!40000 ALTER TABLE `timesheetmanagers` DISABLE KEYS */;
/*!40000 ALTER TABLE `timesheetmanagers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timesheetrecipients`
--

DROP TABLE IF EXISTS `timesheetrecipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timesheetrecipients` (
  `sl_no` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `recipients` varchar(1000) NOT NULL,
  PRIMARY KEY (`sl_no`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timesheetrecipients`
--

LOCK TABLES `timesheetrecipients` WRITE;
/*!40000 ALTER TABLE `timesheetrecipients` DISABLE KEYS */;
/*!40000 ALTER TABLE `timesheetrecipients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timetracking`
--

DROP TABLE IF EXISTS `timetracking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timetracking` (
  `time_tracking_id` int(20) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `date` date NOT NULL,
  `project_id` varchar(100) NOT NULL DEFAULT '0',
  `assignment_id` varchar(150) NOT NULL DEFAULT '0',
  `task` varchar(150) NOT NULL DEFAULT '0',
  `hrs_spend` int(10) NOT NULL,
  `note` varchar(500) NOT NULL,
  `week_range` varchar(10) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `row` int(10) NOT NULL,
  PRIMARY KEY (`time_tracking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timetracking`
--

LOCK TABLES `timetracking` WRITE;
/*!40000 ALTER TABLE `timetracking` DISABLE KEYS */;
/*!40000 ALTER TABLE `timetracking` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timetracking_pat`
--

DROP TABLE IF EXISTS `timetracking_pat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timetracking_pat` (
  `slno` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `timesheet_id` int(15) NOT NULL,
  `row` int(15) NOT NULL,
  `project` varchar(200) DEFAULT NULL,
  `assignment` varchar(200) DEFAULT NULL,
  `task` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timetracking_pat`
--

LOCK TABLES `timetracking_pat` WRITE;
/*!40000 ALTER TABLE `timetracking_pat` DISABLE KEYS */;
/*!40000 ALTER TABLE `timetracking_pat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timetrackingaddons`
--

DROP TABLE IF EXISTS `timetrackingaddons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timetrackingaddons` (
  `ttInfo_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `date` date NOT NULL,
  `time_off` int(11) NOT NULL,
  `time_off_reason` varchar(500) NOT NULL,
  `overtime` int(11) NOT NULL,
  `overtime_details` varchar(500) NOT NULL,
  `tot_working_hrs` int(11) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`ttInfo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timetrackingaddons`
--

LOCK TABLES `timetrackingaddons` WRITE;
/*!40000 ALTER TABLE `timetrackingaddons` DISABLE KEYS */;
/*!40000 ALTER TABLE `timetrackingaddons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timetrackingprefs`
--

DROP TABLE IF EXISTS `timetrackingprefs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timetrackingprefs` (
  `timeTrackingPref_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `skip_weekend` int(1) NOT NULL DEFAULT 0,
  `minimum_entry` int(5) NOT NULL DEFAULT 1,
  `default_task` varchar(100) NOT NULL,
  `timesheetRecipients` varchar(1000) NOT NULL,
  PRIMARY KEY (`timeTrackingPref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timetrackingprefs`
--

LOCK TABLES `timetrackingprefs` WRITE;
/*!40000 ALTER TABLE `timetrackingprefs` DISABLE KEYS */;
/*!40000 ALTER TABLE `timetrackingprefs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timetrackingrolemaster`
--

DROP TABLE IF EXISTS `timetrackingrolemaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timetrackingrolemaster` (
  `role_id` int(5) NOT NULL,
  `role_name` varchar(200) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timetrackingrolemaster`
--

LOCK TABLES `timetrackingrolemaster` WRITE;
/*!40000 ALTER TABLE `timetrackingrolemaster` DISABLE KEYS */;
/*!40000 ALTER TABLE `timetrackingrolemaster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timetrackingtasks`
--

DROP TABLE IF EXISTS `timetrackingtasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timetrackingtasks` (
  `task_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `task_name` varchar(100) NOT NULL,
  `project_id` int(15) NOT NULL,
  PRIMARY KEY (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timetrackingtasks`
--

LOCK TABLES `timetrackingtasks` WRITE;
/*!40000 ALTER TABLE `timetrackingtasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `timetrackingtasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trackmiles`
--

DROP TABLE IF EXISTS `trackmiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `trackmiles` (
  `slno` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `date` date NOT NULL,
  `start_location` varchar(150) NOT NULL,
  `end_location` varchar(150) NOT NULL,
  `distance` float NOT NULL,
  PRIMARY KEY (`slno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trackmiles`
--

LOCK TABLES `trackmiles` WRITE;
/*!40000 ALTER TABLE `trackmiles` DISABLE KEYS */;
/*!40000 ALTER TABLE `trackmiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ttcompanyprefs`
--

DROP TABLE IF EXISTS `ttcompanyprefs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ttcompanyprefs` (
  `tt_admin_pref_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `time_tracking` int(1) NOT NULL DEFAULT 0,
  `overtime` int(1) NOT NULL DEFAULT 0,
  `working_days` varchar(100) NOT NULL DEFAULT '0,1,2,3,4,5,6',
  `daily_working_hours` int(4) DEFAULT 0,
  `change_manager` int(1) NOT NULL DEFAULT 0,
  `minimum_entry` int(5) NOT NULL DEFAULT 1,
  `enable_view` varchar(20) NOT NULL,
  `time_off_reasons` varchar(1000) NOT NULL DEFAULT 'Sick Leave',
  `selected_reasons` varchar(500) NOT NULL,
  `overtime_option` varchar(100) NOT NULL DEFAULT 'daily',
  `weekly_working_hours` int(5) DEFAULT 0,
  PRIMARY KEY (`tt_admin_pref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ttcompanyprefs`
--

LOCK TABLES `ttcompanyprefs` WRITE;
/*!40000 ALTER TABLE `ttcompanyprefs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ttcompanyprefs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `userdefinedpreference`
--

DROP TABLE IF EXISTS `userdefinedpreference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userdefinedpreference` (
  `UserDefinePref_id` int(10) NOT NULL AUTO_INCREMENT,
  `company_id` int(10) NOT NULL,
  `comp_pref_id` int(10) NOT NULL,
  `comp_pref_name` varchar(50) NOT NULL,
  `comp_pref_renamed` varchar(50) NOT NULL,
  `IsActive` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`UserDefinePref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `userdefinedpreference`
--

LOCK TABLES `userdefinedpreference` WRITE;
/*!40000 ALTER TABLE `userdefinedpreference` DISABLE KEYS */;
/*!40000 ALTER TABLE `userdefinedpreference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `userid` int(5) NOT NULL AUTO_INCREMENT,
  `role_id` varchar(20) NOT NULL DEFAULT '3',
  `manager_id` int(5) NOT NULL,
  `manager_name` varchar(100) NOT NULL,
  `companyid` int(5) NOT NULL,
  `IsManager` bit(1) NOT NULL,
  `managerLimit` decimal(20,2) NOT NULL,
  `FirstName` varchar(50) NOT NULL,
  `LastName` varchar(50) NOT NULL,
  `email_id` varchar(100) NOT NULL,
  `Mobile` varchar(12) NOT NULL,
  `Address1` varchar(100) NOT NULL,
  `Address2` varchar(100) DEFAULT NULL,
  `City` varchar(50) NOT NULL,
  `State` varchar(50) NOT NULL,
  `Country` varchar(50) NOT NULL,
  `Zip` varchar(6) NOT NULL,
  `department` varchar(100) NOT NULL,
  `approver` varchar(100) NOT NULL,
  `currency` varchar(50) NOT NULL DEFAULT 'USD',
  `time_tracking_manager_id` int(15) NOT NULL,
  `IsTimeTrackingManager` bit(1) NOT NULL DEFAULT b'0',
  `time_tracking_manager` varchar(100) NOT NULL,
  `unit_of_distance` varchar(50) NOT NULL DEFAULT 'Miles',
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(100) NOT NULL,
  `IsActive` bit(1) NOT NULL,
  `IsFirstLogin` bit(1) NOT NULL DEFAULT b'1',
  PRIMARY KEY (`userid`),
  KEY `companyid` (`companyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `userstatus`
--

DROP TABLE IF EXISTS `userstatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userstatus` (
  `status_id` int(15) NOT NULL AUTO_INCREMENT,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `status_on` varchar(50) NOT NULL,
  `status` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `userstatus`
--

LOCK TABLES `userstatus` WRITE;
/*!40000 ALTER TABLE `userstatus` DISABLE KEYS */;
/*!40000 ALTER TABLE `userstatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `weekly_overtime`
--

DROP TABLE IF EXISTS `weekly_overtime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `weekly_overtime` (
  `overtime_id` int(15) NOT NULL,
  `company_id` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `week_range` varchar(50) NOT NULL,
  `overtime` double(15,2) NOT NULL,
  `description` varchar(2000) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `weekly_overtime`
--

LOCK TABLES `weekly_overtime` WRITE;
/*!40000 ALTER TABLE `weekly_overtime` DISABLE KEYS */;
/*!40000 ALTER TABLE `weekly_overtime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'consu53_DBStructure'
--

--
-- Dumping routines for database 'consu53_DBStructure'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-03  7:48:41
